package gov.va.med.mhv.usermgmt.essapi.service.impl;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.core.validate.EmailValidator;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.essapi.service.NotificationAPIService;
import gov.va.med.mhv.usermgmt.essapi.transfer.NotificationTO;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

public class NotificationAPIServiceImpl implements NotificationAPIService {

	private static final Log log = LogFactory.getLog(NotificationAPIServiceImpl.class);

	@Resource
	private UserMgmtService userMgmtService;
	
	@Autowired
	private UserProfileRepository userProfileRepository;
	
	@Resource
	AccountActivityLogService activityLogService;
	
	@Override
	public Response setRxNotification(NotificationTO notiTO) {
		
		Session session = CacheHandler.getInstance().getSession();
		UserProfile uf = getUserProfile(session);
		if (uf.getContactInfoEmail() == null ) {
			MHVEssApiUtility.throwException(ErrorEnum.USER_NOTIFICATION_NOEMAILADDRESS);
		}
		
		uf.setRxTrackingEmailPref(notiTO.getFlag());
		
		uf = userProfileRepository.saveAndFlush(uf);
		
		try {
			activityLogService.createAccountActivityLog(
										ActivityHelper.createActivityDTO(
										uf.getId(), 
										ActivityActorTypeEnumeration.SYSTEM,
										true, 
										ActivityTypeEnumeration.PROFILES,
										notiTO.getFlag() ? ActivityActionTypeEnumeration.TURN_ON_RX_NOTIFICATIONS
												:ActivityActionTypeEnumeration.TURN_OFF_RX_NOTIFICATIONS, 
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()) 
										)
			);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
		return Response.ok("{\"status\":\"success\" }").build();
	}

	@Override
	public Response setApptNotification(NotificationTO notiTO) {
		Session session = CacheHandler.getInstance().getSession();
		UserProfile uf = getUserProfile(session);
		if (uf.getContactInfoEmail() == null ) {
			MHVEssApiUtility.throwException(ErrorEnum.USER_NOTIFICATION_NOEMAILADDRESS);
		}
		
		uf.setApptReminderEmailPref(notiTO.getFlag());
		
		uf = userProfileRepository.saveAndFlush(uf);
		
		try {
			activityLogService.createAccountActivityLog(
										ActivityHelper.createActivityDTO(
										uf.getId(), 
										ActivityActorTypeEnumeration.SYSTEM,
										true, 
										ActivityTypeEnumeration.PROFILES,
										notiTO.getFlag() ? ActivityActionTypeEnumeration.TURN_ON_VA_APPOINTMENT_REMINDER
												:ActivityActionTypeEnumeration.TURN_OFF_VA_APPOINTMENT_REMINDER, 
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()) 
										)
			);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
		return Response.ok("{\"status\":\"success\" }").build();
	}

	@Override
	public Response setEmailAddrsNotification(NotificationTO notiTO) {
		Session session = CacheHandler.getInstance().getSession();
		UserProfile uf = getUserProfile(session);
	
		if(EmailValidator.isValid(notiTO.getEmailAddress())) {
				uf.setContactInfoEmail(notiTO.getEmailAddress());
		}		
		else 
			MHVEssApiUtility.throwException(ErrorEnum.USER_NOTIFICATION_INVALIDEMAILADDRESS);
			
		uf = userProfileRepository.saveAndFlush(uf);
		
		try {
			activityLogService.createAccountActivityLog(
										ActivityHelper.createActivityDTO(
										uf.getId(), 
										ActivityActorTypeEnumeration.SYSTEM,
										true, 
										ActivityTypeEnumeration.PROFILES,
										ActivityActionTypeEnumeration.UPDATE_EMAIL_ADDRESS, 
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()) 
										)
			);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
		return Response.ok("{\"status\":\"success\" }").build();
	}

	private UserProfile getUserProfile( Session session) {
		return userProfileRepository.getUserProfileById(session.getUserId());
	}
}
